jQuery(document).ready(function ($) {
    $("#confirm-dialog").dialog({
        autoOpen: false,
        resizable: false,
        height: "auto",
        width: 400,
        modal: true,
        buttons: [
            {
                text: "Install",
                click: function () {}
            },
            {
                text: "Back",
                class: "wp-package-back-button",
                click: function () {
                    $(this).dialog("close");
                }
            }
        ],
        open: function () {

            const dialog = this;

            var installButton = $(this).parent().find("button:contains('Install')");

            installButton.off('click').on('click', function () {

                installationHandler.init(dialog, installButton);
            });
        },
        close: function () {}
    });

    $(".install-wp-package").on("click", function (e) {

        e.preventDefault();
        var packageId = $(this).data('package-id');
        var packageData = wpPackageImporter.packages[packageId];

        wpPackageImporter.packages['package_id'] = packageId;

        if (packageData && packageData.isLive) {

            $("#selected-package-name").text(packageData.name);
            $("#confirm-dialog").dialog("open").data('package-id', packageId);
        }
    });
});