const installationHandler = window.installationHandler || {

	requests: [
		{
			progress: [0, 7],
			action: 'wp_pack_step1',
			start_message: 'Starting fresh site...' // Starting fresh site...
		},
		{
			progress: [8, 15],
			action: 'wp_pack_step2',
			start_message: 'Downloading package...' //Downloading package...
		},
		{
			progress: [16, 25],
			action: 'wp_pack_step3',
			start_message: 'Getting design ready...' // Deleting plugins...
		},
		{
			progress: [26, 30],
			action: 'wp_pack_step4',
			start_message: 'Activating your theme...' // Activating your theme...
		},
		{
			progress: [31, 50],
			action: 'wp_pack_step5',
			start_message: 'Performing pre-import setup...'
		},
		{
			progress: [51, 85],
			action: 'wp_pack_step6',
			start_message: 'Importing the content (can take a few minutes)...'
		},
		{
			progress: [86, 98],
			action: 'wp_pack_step7',
			start_message: 'Cleaning up post-installation...'
		},
		{
			progress: [99, 100],
			action: 'wp_pack_step8',
			start_message: 'Cleaning up post-installation...' // All done! Your new website is ready.
		}
	],	

	API_URL: 'https://status.tyler.com/wp-json/package-install-tracker/v1/log-installation',
	// API_URL: 'http://statustyler.local/wp-json/package-install-tracker/v1/log-installation',

	alive: true,

	lifeCycle: null,

	count: 0,

	preventRequest: false,

	packages: null,

	packageId: 'blog-package',

	installButton: null,

	confirmDialog: null,

	statusMessage: null,

	contactUsMessage: null,

	wall: null,

	attempts: 3,

	try: 1,

	beats: 0,

	pluginVersion: 0,

	timeToRefresh: 200,


	baseInterval: 100,

	decreaseSpeedUnit: 2,

	currentProgress: 0,

	decreaseProgressUnit: 0.0008,

	progressUnit: 0.1,

	progressInterval: null,

	heartBeatInterval: 500,

	updateProgress: function (start, end) {

		this.baseInterval = 100;

		this.progressUnit = 0.1;

		const _this = this;

		let progress = start;

		clearInterval(this.progressInterval);

		this.progressInterval = setInterval(function () {

			if(_this.currentProgress<=end) {

				progress += _this.progressUnit;

				_this.currentProgress = progress;

				_this.setProgressBar(_this.currentProgress + '%');

				_this.baseInterval += _this.decreaseSpeedUnit;

				if(_this.progressUnit>0.05) {

					_this.progressUnit -= _this.decreaseProgressUnit;
				}
			}
		}, this.baseInterval );
	},

	countProgress: function (currentStep) {

		return currentStep / (this.requests.length / 100);
	},

	reportInstallationStatus: function (status, message) {
		
		const body = {
			site_url: wpPackageImporter.siteUrl,
			package_name: wpPackageImporter.packages[this.packageId].name,
			status: status,
			message: message,
			wp_version: wpPackageImporter.wpVersion,
			php_version: wpPackageImporter.phpVersion,
			plugin_version: wpPackageImporter.plugin_version
		};

		fetch(this.API_URL, {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json',
			},
			body: JSON.stringify(body)
		})
			.then(response => {
				if (!response.ok) {
					throw new Error('Network response was not ok');
				}
				return response.json();
			})
			.then(data => {
				// console.log('Data sent successfully to external server:', data);
			})
			.catch(error => {
				console.error('Error reporting installation status:', error);
			});
	},

	sendPostRequest: function () {

		if (this.beats > this.timeToRefresh) {

			this.beats = 0;
			this.preventRequest = false;
			console.log('Refresh request.');
		}

		if (this.preventRequest) return;

		// Set Progress Bar
		const currentProgress = this.countProgress(this.count);
		// this.setProgressBar(currentProgress + '%');

		if ((this.count + 1) > this.requests.length) {

			// console.log('stop');
			// this.successNotification('All done! Your new website is ready.');
			this.setProgressBar('100%');

			this.finishInstall();

			this.reportInstallationStatus('success', 'Installed successfully.');

			this.alive = false;

			return;
		} else {

			this.updateProgress(this.requests[this.count]['progress'][0], this.requests[this.count]['progress'][1]);
		}

		this.preventRequest = true;

		const _this = this;
		const request = this.requests[this.count];

		this.successNotification(request.start_message);

		request.nonce = wpPackageImporter.nonce;
		request.packageId = this.packageId;
		request.packages = wpPackageImporter.packages;

		jQuery.post(wpPackageImporter.ajax_url, request, function (response) {

			// console.log('response', response);

			// 'All done'
			if (_this.isJSON(response)) {

				const res = JSON.parse(response);

				if (res.status === 200) {
					// Success

					_this.stepSucceed(_this, res.data.message);
				} else {

					// set attempts
					if (_this.try < _this.attempts) {

						// console.log('Attempt ' + _this.try);

						_this.preventRequest = false;
						_this.try++
					} else {

						// error
						_this.stepFailed(_this, res?.errors?.error_data, response);
					}
				}
			} else {

				if (_this.checkResponse(response)) {

					// success
					_this.stepSucceed(_this, 'Content Imported successfully!');
				} else {

					// error
					_this.stepFailed(_this, ['Content Import Issue'], response);
				}
			}

			_this.preventRequest = false;
		});

	},

	stepFailed(_this, error_data, response) {

		if (error_data) {

			const message = 'Error on step ' + (_this.count + 1) + ': ' + error_data.join(',');

			_this.failedNotification(message);

			_this.reportInstallationStatus('Error', message);
		}

		console.log('Here is an error: ', response);

		_this.alive = false;

		_this.finishInstall();

		_this.setProgressBar('100%', false, true);
	},

	stepSucceed(_this, message) {

		_this.successNotification(message);
		_this.count++;

		// console.log(_this.count, ' step completed');

		// Refresh attempts
		_this.try = 1;

		// Set Step progress
		// _this.setStepProgressBar(100);

		// Refresh beats
		_this.beats = 0
	},

	checkResponse(serverResponse) {

		return serverResponse.includes("Have fun!");
	},

	startInstall: function () {

		if (jQuery('.ui-dialog').find(this.wall).length === 0) {

			jQuery('.ui-dialog').append(this.wall);

			const _this = this;

			this.wall.on('click', function () {

				_this.showAlert('Please wait! Do not close the window until the installation is complete.', 'warning');
			});
		}

		this.installButton.text("Installing...").prop('disabled', true);
	},

	showAlert: function (message, type = 'success') {

		clearTimeout(this.alertTimeout);

		const alertSelector = '.wp-packages-alert';

		if (jQuery('body').find(alertSelector).length !== 0) {

			jQuery('body').find(alertSelector).remove();
		}

		const alert = jQuery('<div class="wp-packages-alert alert-type-' + type + '"><p>' + message + '</p></div>');

		jQuery('body').append(alert);

		const button = jQuery('<button>x</button>');

		jQuery(alertSelector).append(button);

		button.on('click', function () {

			jQuery('body').find(alertSelector).remove();
		});

		this.alertTimeout = setTimeout(function () {

			if (jQuery('body').find(alertSelector).length !== 0) {

				jQuery('body').find(alertSelector).remove();
			}
		}, 3000);
	},

	finishInstall: function () {

		if ((this.count + 1) >= this.requests.length) {

			this.successNotification('All done! Your new website is ready.');
			this.installButton.text("View website").prop('disabled', false);
			this.installButton.off('click').on('click', function () {
				window.open(wpPackageImporter.siteUrl, '_blank');
			});
		} else {

			this.installButton.text("Failed");
		}

		this.wall.remove();

		// Close dialog
		jQuery('.ui-dialog-titlebar-close, .wp-package-back-button').on('click', function () {

			window.location.reload();
		});

		window.removeEventListener('beforeunload', this.preventClosing);
	},

	heartBeat: function () {

		const _this = this;

		// start install
		_this.startInstall();

		// start immediately
		_this.runRequestBody(_this);

		this.lifeCycle = setInterval(function () {

			_this.runRequestBody(_this);
		}, _this.heartBeatInterval);
	},

	runRequestBody: function (_this) {

		if (!_this.alive) {
			clearInterval(_this.lifeCycle);
			return;
		}

		// step
		if ((_this.count + 1) <= _this.requests.length) {

			_this.beats++;
			// console.log('Beat. (v-' + _this.pluginVersion + ') Current step is: ', _this.count + 1);
		}

		// Set Step progress
		// _this.setStepProgressBar();

		// make requests
		_this.sendPostRequest();
	},

	failedNotification: function (message) {

		if (!this.statusMessage) return;

		this.statusMessage.text(message);
		this.statusMessage.attr('style', '');

		// contact us message
		this.confirmDialog.append(this.contactUsMessage);
	},

	successNotification: function (message) {

		if (!this.statusMessage) return;

		this.statusMessage.text(message);
		this.statusMessage.css('border-left-color', '#00a32a');
	},

	setProgressBar: function (width, force = false, failed = false) {

		if (!this.confirmDialog) return;

		const progressBar = this.confirmDialog.find('#progress-bar-container');

		if (progressBar.length === 0) {

			this.confirmDialog.append('<div id="progress-bar-container"><div id="progress-bar" style="width: 0%"></div></div>');
		}

		if (!width) {

			width = '0%';
		}

		if (force) {

			jQuery('#progress-bar').hide();
		}

		jQuery('#progress-bar').css('width', width);

		if (failed) {

			clearInterval(this.progressInterval);

			jQuery('#progress-bar')
				.css('background-color', '#dc3232')
				.css('width', '100%')
				.css('transition', 'none');
		}

		if( parseInt(width) >= 90 ) {

			jQuery('#progress-bar').css('transition', 'none');			
		}
	},

	setStepProgressBar: function (percentage = 0) {

		let width = parseInt(this.beats / (this.timeToRefresh / 100)) + '%';

		if (percentage) {
			width = parseInt(percentage) + '%';
		}

		if (!this.statusMessage) return;

		const progressBar = this.statusMessage.find('#wp-pack-step-progress');

		if (progressBar.length === 0) {

			this.statusMessage.append('<div id="wp-pack-step-progress"></div>');
		}

		if (!width) {
			width = '0%';
		}

		jQuery('#wp-pack-step-progress').animate({ 'width': width }, 300);
	},

	isJSON: function (str) {

		try {

			JSON.parse(str);
		} catch (e) {

			return false;
		}
		return true;
	},

	preventClosing: function (e) {

		e.preventDefault();
		e.returnValue = '';
	},

	init: function (dialog, installButton) {

		this.packageId = wpPackageImporter.packages['package_id'];

		this.wall = jQuery('<div class="wp-packages-transparent-wall"></div>');

		this.installButton = installButton;

		this.confirmDialog = jQuery(dialog);

		this.statusMessage = jQuery("#status-message");

		this.contactUsMessage = '<p class="additional-status-message" style="border-left-color: #FFD494;">Please refresh this page and try again. If you keep getting this error, <a href="https://tyler.com/" target="_blank">go to tyler.com</a> and click Feedback on the left to get assistance from us. We reply within 24 hours.</p>',		

		this.pluginVersion = wpPackageImporter.plugin_version;

		this.heartBeat();

		// Ask not reload the page
		window.addEventListener('beforeunload', this.preventClosing);
	}
};
