<?php

if (!defined('ABSPATH')) {
    exit;
}

class HandleStepThree
{

    public function __construct()
    {

        add_action('wp_ajax_wp_pack_step3', [$this, 'handle_step']);
    }

    public function handle_step()
    {

        // Checked POST nonce is not empty.
        if (empty($_POST['nonce'])) wp_die('0');

        $nonce = sanitize_key(wp_unslash($_POST['nonce']));

        if (!wp_verify_nonce($nonce, 'install_wp_package')) {

            echo wp_json_encode(new WP_Error('error_data', 'Invalid nonce', array('status' => 403))); // {"errors":{"invalid_nonce":["Invalid nonce"]},"error_data":{"invalid_nonce":{"status":403}}}

            wp_die();
        }

        /**
         * Execution code here
         */
        // Disable Cron
        (new WP_CRON_Manager)->disable_wp_cron();

        // Cancel schedules
        $this->cancelScheduledHooks();

        // Download package
        $this->deleteInactivePlugins();

        // Success
        echo wp_json_encode(new WP_REST_Response([
            'success' => true,
            'message' => 'Getting design ready...'//'Plugins deleted successfully'
        ], 200)); // {"data":{"success":true,"message":"This is a success"},"headers":[],"status":200}

        wp_die();
    }

    public function deleteInactivePlugins()
    {

        $all_plugins = get_plugins();
        $active_plugins = get_option('active_plugins');

        foreach ($all_plugins as $plugin_path => $plugin_data) {

            if (!in_array($plugin_path, $active_plugins)) {

                $plugin_dir = WP_PLUGIN_DIR . '/' . dirname($plugin_path);
                $plugin_file = WP_PLUGIN_DIR . '/' . $plugin_path;

                // If this is a file, most likely Hello Dolly, delete the file not the whole plugins directory
                if (dirname($plugin_path) === '.') {

                    wp_delete_file($plugin_file);
                } else {

                    wp_packages_delete_directory($plugin_dir);
                }
            }
        }

        // Flush caches (prevent plugin folder not found errors)
        wp_clean_plugins_cache(true);
        wp_cache_flush();
    }

    public function cancelScheduledHooks()
    {

        if (!function_exists('wp_clear_scheduled_hook') || !function_exists('wp_next_scheduled')) {

            require_once ABSPATH . 'wp-includes/cron.php';
        }

        if (wp_next_scheduled('wpforms_weekly_entries_count_cron')) {

            wp_clear_scheduled_hook('wpforms_weekly_entries_count_cron');
        }

        if (wp_next_scheduled('wpforms_email_summaries_cron')) {

            wp_clear_scheduled_hook('wpforms_email_summaries_cron');
        }

        if (class_exists('ActionScheduler_QueueRunner')) {

            ActionScheduler_QueueRunner::instance()->unhook_dispatch_async_request();
        }

        if (wp_next_scheduled('wpseo_indexable_index_batch')) {

            wp_clear_scheduled_hook('wpseo_indexable_index_batch');
        }

        if (wp_next_scheduled('action_scheduler_run_queue')) {

            wp_clear_scheduled_hook('action_scheduler_run_queue');
        }

        if (wp_next_scheduled('woocommerce_geoip_updater')) {

            wp_clear_scheduled_hook('woocommerce_geoip_updater');
        }
    }
}
