<?php

if (!defined('ABSPATH')) {
    exit;
}

class HandleStepFour
{

    public function __construct()
    {

        add_action('wp_ajax_wp_pack_step4', [$this, 'handle_step']);
    }

    public function handle_step()
    {

        // Checked POST nonce is not empty.
        if (empty($_POST['nonce'])) wp_die('0');

        $nonce = sanitize_key(wp_unslash($_POST['nonce']));

        if (!wp_verify_nonce($nonce, 'install_wp_package')) {

            echo wp_json_encode(new WP_Error('error_data', 'Invalid nonce', array('status' => 403))); // {"errors":{"invalid_nonce":["Invalid nonce"]},"error_data":{"invalid_nonce":{"status":403}}}

            wp_die();
        }

        /**
         * Execution code here
         */
        // Disable Cron
        (new WP_CRON_Manager)->disable_wp_cron();

        // Extract Theme
        $this->extractTheme();

        // Success
        echo wp_json_encode(new WP_REST_Response([
            'success' => true,
            'message' => 'Activating your theme...'//'Theme activated successfully'
        ], 200)); // {"data":{"success":true,"message":"This is a success"},"headers":[],"status":200}

        wp_die();
    }

    public function extractTheme()
    {

        // Get extract path
        $extract_path = get_option('wp_package_extract_path');

        if (!$extract_path) {

            echo wp_json_encode(new WP_Error('error_data', 'Not Path Option', array('status' => 404)));

            wp_die();
        }

        // Find any zip file in the extracted package
        $theme_zip = glob($extract_path . '/*.zip');

        if (empty($theme_zip)) {

            echo wp_json_encode(new WP_Error('error_data', 'No theme zip file found in the extracted package.', array('status' => 404)));

            wp_die();
        }
        $theme_zip = $theme_zip[0]; // Get the first (and only) zip file found

        // Extract the theme
        $theme_extract_path = get_theme_root();
        $zip = new ZipArchive;

        if ($zip->open($theme_zip) === TRUE) {

            // Get the theme directory name from the zip contents
            $theme_dir = trim($zip->getNameIndex(0), '/');
            $zip->extractTo($theme_extract_path);
            $zip->close();
        } else {

            echo wp_json_encode(new WP_Error('error_data', 'Failed to extract the theme zip file.', array('status' => 500)));

            wp_die();
        }

        // Activate the theme
        switch_theme($theme_dir);
    }
}
