<?php

if (!defined('ABSPATH')) {
    exit;
}

class HandleStepFive
{

    public function __construct()
    {

        add_action('wp_ajax_wp_pack_step5', [$this, 'handle_step']);
    }

    public function handle_step()
    {

        // Checked POST nonce is not empty.
        if (empty($_POST['nonce'])) wp_die('0');

        $nonce = sanitize_key(wp_unslash($_POST['nonce']));

        if (!wp_verify_nonce($nonce, 'install_wp_package')) {

            echo wp_json_encode(new WP_Error('error_data', 'Invalid nonce', array('status' => 403))); // {"errors":{"invalid_nonce":["Invalid nonce"]},"error_data":{"invalid_nonce":{"status":403}}}

            wp_die();
        }

        /**
         * Execution code here
         */
        // Disable Cron
        (new WP_CRON_Manager)->disable_wp_cron();

        if(empty($_POST['packages'])) {

            echo wp_json_encode(new WP_Error('error_data', 'Missing of the packages', array('status' => 404)));

            wp_die();
        }
        $packages   = wpPackagesSanitizePostArray($_POST['packages']);
        
        if(empty($_POST['packageId'])) {

            echo wp_json_encode(new WP_Error('error_data', 'Missing of the packageId', array('status' => 404)));

            wp_die();
        }

        $package_id = sanitize_text_field(wp_unslash($_POST['packageId']));

        // Extract Theme
        $this->preImport($packages[$package_id]);

        // Success
        echo wp_json_encode(new WP_REST_Response([
            'success' => true,
            'message' => 'Performing pre-import setup...'//'Pre import was successful'
        ], 200)); // {"data":{"success":true,"message":"This is a success"},"headers":[],"status":200}

        wp_die();
    }

    public function preImport($package)
    {

        if (isset($package['pre_import_steps']) && is_array($package['pre_import_steps']) && !empty($package['pre_import_steps'])) {

            $steps = $package['pre_import_steps'];

            foreach ($steps as $step) {

                switch ($step) {
                    case 'install_wpforms':
                        $this->install_wpforms();
                        break;
                }
            }
        }
    }

    public function install_wpforms()
    {

        // Download and activate WPForms plugin
        include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
        include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
        include_once(ABSPATH . 'wp-admin/includes/misc.php');
        include_once(ABSPATH . 'wp-admin/includes/file.php');

        $plugin_slug = 'wpforms-lite';
        $plugin = $plugin_slug . '/wpforms.php';

        if (!is_plugin_active($plugin)) {

            $api = plugins_api('plugin_information', array('slug' => $plugin_slug));

            if (is_wp_error($api)) {

                echo wp_json_encode(new WP_Error('error_data', 'Failed to get WPForms plugin: ' . $api->get_error_message(), array('status' => 404)));

                wp_die();
            }

            $upgrader = new Plugin_Upgrader(new Quiet_Skin());
            $result = $upgrader->install($api->download_link);

            if (is_wp_error($result)) {

                echo wp_json_encode(new WP_Error('error_data', 'Failed to install WPForms plugin: ' . $result->get_error_message(), array('status' => 404)));

                wp_die();
            }

            activate_plugin($plugin, '', false, true);
        }
    }
}
