<?php

if (!defined('ABSPATH')) {
    exit;
}

class WP_CRON_Manager
{

    private $original_cron_state;

    public function disable_wp_cron()
    {

        $this->original_cron_state = defined('DISABLE_WP_CRON') ? DISABLE_WP_CRON : false;
        $this->remove_wp_cron_jobs();        
    }

    private function remove_wp_cron_jobs()
    {

        remove_action('wp_version_check', 'wp_version_check');
        remove_action('wp_update_plugins', 'wp_update_plugins');
        remove_action('wp_update_themes', 'wp_update_themes');
        remove_action('wp_scheduled_delete', 'wp_scheduled_delete');
        remove_action('wp_scheduled_auto_draft_delete', 'wp_delete_auto_drafts');
    }

    public function re_enable_wp_cron()
    {
        remove_filter('pre_option_cron', array($this, 'prevent_cron_running'));
        $this->restore_wp_cron_jobs();

        // If WP Cron was originally enabled, trigger missed schedule events
        if (!$this->original_cron_state) {
            spawn_cron();
        }
    }

    private function restore_wp_cron_jobs()
    {
        add_action('wp_version_check', 'wp_version_check');
        add_action('wp_update_plugins', 'wp_update_plugins');
        add_action('wp_update_themes', 'wp_update_themes');
        add_action('wp_scheduled_delete', 'wp_scheduled_delete');
        add_action('wp_scheduled_auto_draft_delete', 'wp_delete_auto_drafts');
    }
}
